/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote.common;

import cz.insophy.inplan.util.Formatter;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Date;

public class SuperplanDescriptorDataHolder
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final long revision;
    private final String name;
    private final Date date;
    private final int variant;
    private final String description;

    public SuperplanDescriptorDataHolder(long revision, int variant, Date date, String name, String description) {
        this.revision = revision;
        this.variant = variant;
        this.date = date;
        this.name = name;
        this.description = description;
    }

    public long getRevision() {
        return this.revision;
    }

    public int getVariant() {
        return this.variant;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        if (this.getDate() == null) {
            return "Rev. " + this.revision + "; var. " + this.variant + ": " + this.name;
        }
        return "Rev. " + this.revision + "; var. " + this.variant + ": " + Formatter.formatShortDateTime(this.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }
}

